/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blockentity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class PizzaHungerSystem {
    public static final int BASE_HUNGER = 7;
    public static final Float BASE_SATURATION = Float.valueOf(2.8f);
    private final ItemStackHandler handler;
    private final NonNullList<ItemStack> ingredients;
    private int hunger;
    private float saturation;
    private List<Pair<MobEffectInstance, Float>> effects;

    public PizzaHungerSystem(ItemStackHandler handler) {
        this.handler = handler;
        this.ingredients = this.setupIngredients();
        this.effects = new ArrayList<Pair<MobEffectInstance, Float>>();
        this.execute();
    }

    public NonNullList<ItemStack> setupIngredients() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).m_41619_()) continue;
            ingredients.add((Object)this.handler.getStackInSlot(i));
        }
        return ingredients;
    }

    public void execute() {
        int baseHunger = 7;
        float baseSaturation = BASE_SATURATION.floatValue();
        ArrayList<Pair<MobEffectInstance, Float>> effects = new ArrayList<Pair<MobEffectInstance, Float>>();
        for (ItemStack foodStack : this.ingredients) {
            if (!foodStack.m_41614_()) continue;
            FoodProperties food = foodStack.m_41720_().m_41473_();
            baseHunger += food.m_38744_() * foodStack.m_41613_();
            baseSaturation += food.m_38745_() * (float)foodStack.m_41613_();
            if (food.m_38749_().isEmpty()) continue;
            List foodEffects = food.m_38749_();
            effects.addAll(foodEffects);
        }
        this.hunger = baseHunger;
        this.saturation = baseSaturation;
        this.effects = effects;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public List<Pair<MobEffectInstance, Float>> getEffects() {
        return this.effects;
    }

    public void applyModifiersForIngredients(NonNullList<ItemStack> ingredients) {
    }
}

